' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.Data.SqlClient

''' <summary>
''' Klasa CategoryDB jest uywana do przesyania kategorii (zarwno pojedynczych egzemplarzy jak i list) do i z bazy danych.
''' </summary>
Public Class CategoryDB

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy CategoryDB.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca pen ciek danej kategorii (dan kategori wraz z wszystkimi rodzicami).
  ''' </summary>
  ''' <param name="categoryId">Identyfikator kategiii, ktrej rodzice maj by zwrceni.</param>
  ''' <returns>DataSet z Id, Description oraz Id kategorii macierzystej.</returns>
  Public Shared Function GetCategoryPath(ByVal categoryId As Integer) As DataSet
    Dim myDataSet As DataSet = New DataSet()
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocCategorySelectPath", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@categoryId", categoryId)

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)
        myConnection.Close()
        Return myDataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Tworzy now kategori w bazie danych.
  ''' </summary>
  ''' <param name="description">Opis nowej kategorii.</param>
  ''' <param name="parentCategoryId">Identyfikator kategorii macierzystej. Jeli jest mniejszy lub rwny zero, twrzona jest kategoria gwna.</param>
  Public Shared Sub CreateCategory(ByVal description As String, ByVal parentCategoryId As Integer)
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

      Dim myCommand As SqlCommand = New SqlCommand("sprocCategoryInsertUpdateSingleItem", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      If parentCategoryId > 0 Then
        myCommand.Parameters.AddWithValue("@parentCategoryId", parentCategoryId)
      Else
        myCommand.Parameters.AddWithValue("@parentCategoryId", DBNull.Value)
      End If
      myCommand.Parameters.AddWithValue("@description", description)

      myConnection.Open()
      myCommand.ExecuteNonQuery()
      myConnection.Close()
    End Using
  End Sub

  ''' <summary>
  ''' Zwraca list kategorii.
  ''' </summary>
  ''' <param name="parentCategoryId">Identyfikator kategorii macierzystej, jeli jest wymagany.</param>
  ''' <returns>DataSet zawierajcy identyfikatory i opisy danych kategorii.</returns>
  ''' <remarks>Jeli <paramref name="parentCategoryId"/> jest mniejszy lub rwny zero, zwracane s gwne kategorie. W przeciwnym wypadku zwracane s kategorie potomne dla podanego categoryId.</remarks>
  Public Shared Function GetCategoryList(ByVal parentCategoryId As Integer) As DataSet
    Dim myDataSet As DataSet = New DataSet()
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
      Dim myCommand As SqlCommand = New SqlCommand("sprocCategorySelectList", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      If parentCategoryId > 0 Then
        myCommand.Parameters.AddWithValue("@parentCategoryId", parentCategoryId)
      Else
        myCommand.Parameters.AddWithValue("@parentCategoryId", DBNull.Value)
      End If

      Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
      myDataAdapter.SelectCommand = myCommand
      myDataAdapter.Fill(myDataSet)
      myConnection.Close()
      Return myDataSet
    End Using
  End Function
End Class
